<?php
class CustomizeComponent extends Object {

    public $font;  //default font. directory relative to script directory.
    public $msg = "no text"; // default text to display.
    public $size = 4; // default font size.
    public $rot = 0; // rotation in degrees.
    public $fore = '000000'; // on white background.
    public $outline; // outline if any.
    public $outlinecolor; // outline color.
    public $allignment = 'center';
    public $textShape = 'normal';
    public $textShapeSettings = 12;
    private $gravity;
    private $padding = 2;
    private $dpi = 300;
    
    private $original;
    private $edited;
    private $imageType;
    private $editCount;
    private $top = 0;
    private $left = 0;
    private $imageSrc;

    function index($imagePath, $foregorund = false) {
        
        $this->original = WWW_ROOT . IMAGES_URL . $imagePath;
        //----------Find the format of the original image-----------//
        $tmp = explode(".", $imagePath);
        $this->imageType = strtolower(end($tmp));

        if (!$foregorund)
            $editedImg = "customized_tshirts/img_" . $this->__getmicrotime() . "." . $this->imageType;
        else
            $editedImg = "customized_tshirts_foreground/img_" . $this->__getmicrotime() . "." . $this->imageType;
        $this->edited = WWW_ROOT . IMAGES_URL . $editedImg;
        $this->editCount = 0;

        return $editedImg;
        
    }

    function imgPreview($imagePath, $foregorund = false) {
        
        $this->original = WWW_ROOT . IMAGES_URL . $imagePath;
        //----------Find the format of the original image-----------//
        $tmp = explode(".", $imagePath);
        $this->imageType = strtolower(end($tmp));

        if (!$foregorund)
            $editedImg = "customized_tshirts/preview/img_" . $this->__getmicrotime() . "." . $this->imageType;
        else
            $editedImg = "customized_tshirts_foreground/preview/img_" . $this->__getmicrotime() . "." . $this->imageType;
        $this->edited = WWW_ROOT . IMAGES_URL . $editedImg;
        $this->editCount = 0;

        return $editedImg;
        
    }
    
    //---------------------------TEXT SECTION---------------------------------//
    function addText($textVal) {
            
        if(is_array($textVal)) {

            $this->editCount++;
            $dest = $this->editCount == 1 ? $this->original : $this->edited;

            $this->msg                  = $textVal['msg'];
            $this->allignment           = $textVal['align'];
            $this->outline              = $textVal['outline'];
            $this->textShape            = $textVal['shape'];
            $this->fore                 = $textVal['foreColor'];
            $this->size                 = $textVal['foreSize'];
            $this->outlinecolor         = $textVal['outlineColor'];
            $this->textShapeSettings    = $textVal['shapeSettings'];
            $this->rot                  = $textVal['rotation'];
            $this->left                 = $textVal['left'];
            $this->top                  = $textVal['top'];

            if (file_exists(WWW_ROOT . IMAGES_URL . 'editorfonts/' . $textVal['font'] . '.ttf')) {
                $this->font = WWW_ROOT . IMAGES_URL . 'editorfonts/' . $textVal['font'] . '.ttf';
            } else {
                $this->font = WWW_ROOT . IMAGES_URL . 'editorfonts/' . $textVal['font'] . '.TTF';
            }

            $this->msg = $this->__br2nl($this->msg);
            $this->msg=str_replace('\\','1',$this->msg);
            $this->msg = str_replace("/n", "\n ", $this->msg);
            $this->msg=str_replace('"','\"',$this->msg);
            $this->msg=preg_replace("/(\r\n|\n|\r|\t)/i", '\n ', $this->msg);

            switch($this->allignment) {
                    case 'left':
                            $this->gravity="west";
                            break;
                    case 'right':
                            $this->gravity="east";
                            break;
                    default:
                            $this->gravity="center";
                            break;
            }

            switch($this->outline) {
                    case 'Thin':
                            $this->padding=2;
                            break;
                    case 'Medium':
                            $this->padding=4;
                            break;
                    case 'Thick':
                            $this->padding=6;
                            break;
                    default:
                            $this->padding=2;
                            break;
            }

            switch($this->textShape) {
                    case 'normal':
                            $this->drawNormal($dest);
                            break;
                    case 'curve':
                            $this->drawCurve($dest);
                            break;
                    case 'arc':
                           $this->drawArc($dest);
                            break;
                    case 'wedge':
                            $this->drawWedge($dest);
                            break;
                    case 'roof':               
                            $this->drawRoof($dest);
                            break;
                    default:
                            $this->drawNormal($dest);
                            break;
            }

        }
        
    }
    
    private function drawNormal($destImage) {
        
	$pngName = time().rand(0, 9999).'.png';

        //FOR NORMAL DRAWING
	system('convert -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.' -stroke none -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	
        //FOR OUTLINE DRAWING	
	if(($this->outline <> 'None')) {
            
		$stokewidthcmd=' -strokewidth '.$this->padding.' -stroke "#'.$this->outlinecolor.'"';
		system('convert -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.$stokewidthcmd.' -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
		system('composite -gravity center '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
		unlink(WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
                
	}

        //FOR ROATATION
	system('convert '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' -virtual-pixel transparent -distort Arc 1,'.$this->rot.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);

        //SUPERIMPOSE OVER THE FINAL IMAGE
        system('composite -geometry +' . $this->left . '+' . $this->top . ' ' . WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName . ' ' . $destImage . ' ' . $this->edited);
   	
         $src=WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName;
        if(is_file($src)) {
        
        	//For SVG
        	$tmp = explode(".", $this->edited);
        	$this->editedImg_svg=$tmp[0].".svg";
        
        	$src_svg=explode(".",$src);
        	$src_svg=$src_svg[0].".gif";
        	system('convert -channel Alpha -threshold 80% '.$src." ".$src_svg);
        	
        	// copy($src, WWW_ROOT . IMAGES_URL ."1.png");
        	if(file_exists($this->editedImg_svg))
        	{
        	
        		$svg = SVGDocument::getInstance($this->editedImg_svg);
        		$svg->addShape( SVGImage::getInstance($this->left, $this->top, 'Text'.$this->editCount,$src_svg));
        		$svg->asXML($this->editedImg_svg);
        	}
        	 
        	unlink($src_svg);
        
        }
        
        
        
        
        
        unlink(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
        
    }
    
    private function drawCurve($destImage) {
        
	$pngName = time().rand(0, 9999).'.png';

	switch($this->textShapeSettings) {
		case 1 :      
                        $curve= 270;
                        break;
		case 2: 	
         		$curve = 180;
         		break;
		case 3: 	
         		$curve = 90;
         		break;
		case 4:			
        		$curve = 45;
        		break;
		case 5: 		
         		$curve = 22.5;
         		break;
		case 6: 		
         		$curve = 11.25;
         		break;			
		case 7 :              
                        $curve= 270;
                        break;
		case 8: 	
                        $curve = 180;
                        break;
		case 9: 		
                        $curve = 90;
                        break;
		case 10:	
                        $curve = 45;
                        break;
		case 11: 	
                        $curve = 22.5;
                        break;
		case 12: 		
                        $curve = 11.25;
                        break;
		default:
         		$curve = 0;
        		break;
	}
	
	if($this->textShapeSettings > 6) {
		$this->rot -= 180;
	}
	else {
		$this->rot = $this->rot;
	}
	
	//FOR NORMAL DRAWING
	system('convert -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.' -stroke none -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);

	//FOR OUTLINE DRAWING
	if(($this->outline <> 'None'))
	{
            $stokewidthcmd=' -strokewidth '.$this->padding.' -stroke "#'.$this->outlinecolor.'"';
            system('convert -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.$stokewidthcmd.' -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
            system('composite -gravity center '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
            unlink(WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
	}

	//FOR Distorted ARC ROATATION
	if($this->textShapeSettings>6)
	{
            system('convert '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' -virtual-pixel transparent -rotate 180 -distort Arc '.$curve.','.$this->rot.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
	else
	{
            system('convert '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' -virtual-pixel transparent -distort Arc '.$curve.','.$this->rot.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
        
        //SUPERIMPOSE OVER THE FINAL IMAGE
        system('composite -geometry +' . $this->left . '+' . $this->top . ' ' . WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName . ' ' . $destImage . ' ' . $this->edited);
        
        $src=WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName;
        
        if(is_file($src)) {
        
        	//For SVG
        	$tmp = explode(".", $this->edited);
        	$this->editedImg_svg=$tmp[0].".svg";
        	$src_svg=explode(".",$src);
        	$src_svg=$src_svg[0].".gif";
        	system('convert -channel Alpha -threshold 80% '.$src." ".$src_svg);
        	 
        	// copy($src, WWW_ROOT . IMAGES_URL ."1.png");
        	if(file_exists($this->editedImg_svg))
        	{
        		 
        		$svg = SVGDocument::getInstance($this->editedImg_svg);
        		$svg->addShape( SVGImage::getInstance($this->left, $this->top, 'Text'.$this->editCount,$src_svg));
        		$svg->asXML($this->editedImg_svg);
        	}
        	
        	unlink($src_svg);
        
        }
        
        
        unlink(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
        
    }
    
    private function drawArc($destImage) {
        
	$pngName = time().rand(0, 9999).'.png';

	switch($this->textShapeSettings) {
		case 1 :                  
                        $arc= 5;
                        break;
		case 2: 		
                        $arc = 4;
                        break;
		case 3: 
                        $arc = 3;
                        break;
		case 4:		
                        $arc = 2;
                        break;
		case 5: 	
                        $arc = 1;
                        break;
		case 6: 
                        $arc = 5;
                        break;
		case 7 :                  
                        $arc= 4;
                        break;
		case 8: 		
                        $arc = 3;
                        break;
		case 9: 			
                        $arc = 2;
                        break;
		case 10:			
                        $arc = 1;
                        break;	
		default:
                        $arc = 1;
                        break;
	}

	//FOR NORMAL DRAWING
	system('convert -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.' -stroke none -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);

	//FOR OUTLINE DRAWING
	if(($this->outline <> 'None'))
	{
		$stokewidthcmd=' -strokewidth '.$this->padding.' -stroke "#'.$this->outlinecolor.'"';
		system('convert -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.$stokewidthcmd.' -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
		system('composite -gravity center '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
		unlink(WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
	}

	$size = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	$width = $size[0] * 2;
	$height = $size[1];
	
	//FOR Distorted ARC ROATATION
	if($this->textShapeSettings > 5)
	{
		system('convert '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' -background transparent -virtual-pixel transparent -rotate 180 -wave '.$height/$arc.'x'.$width.' -distort Arc 1,'.($this->rot+180).' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
	else
	{
		system('convert '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' -background transparent -virtual-pixel transparent -wave '.($height/$arc).'x'.$width.' -chop 0x'.($height/$arc).' -distort Arc 1,'.$this->rot.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
        
        //SUPERIMPOSE OVER THE FINAL IMAGE
        system('composite -geometry +' . $this->left . '+' . $this->top . ' ' . WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName . ' ' . $destImage . ' ' . $this->edited);
	
        $src=WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName;
        if(is_file($src)) {
        
        	//For SVG
        	$tmp = explode(".", $this->edited);
        	$this->editedImg_svg=$tmp[0].".svg";
        
        	$src_svg=explode(".",$src);
        	$src_svg=$src_svg[0].".gif";
        	system('convert -channel Alpha -threshold 80% '.$src." ".$src_svg);
        	 
        	// copy($src, WWW_ROOT . IMAGES_URL ."1.png");
        	if(file_exists($this->editedImg_svg))
        	{
        		 
        		$svg = SVGDocument::getInstance($this->editedImg_svg);
        		$svg->addShape( SVGImage::getInstance($this->left, $this->top, 'Text'.$this->editCount,$src_svg));
        		$svg->asXML($this->editedImg_svg);
        	}
        	
        	unlink($src_svg);
        }
        
        
        
        unlink(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	
    }
    
    private function drawWedge($destImage) {
        
	$pngName = time().rand(0, 9999).'.png';

	switch($this->textShapeSettings) {
            
		case 1 :         
                        $wedgesize= 4;
                        break;
		case 2: 	
         		$wedgesize=3;
         		break;
                case 3: 	
                        $wedgesize=  2;
                        break;
                case 4: 	
                        $wedgesize=  4;
                        break;
                case 5: 
                        $wedgesize=  3;
                        break;
                case 6: 	
                        $wedgesize=  2;
                        break;
                case 7: 	
                        $wedgesize=  5;
                        break;
                case 8: 	
                        $wedgesize=  4;
                        break;
                case 9: 	
                        $wedgesize=  3;
                        break;
                case 10: 	
                        $wedgesize=  5;
                        break;
                case 11: 	
                        $wedgesize=  4;
                        break;
                case 12: 	
                        $wedgesize=  3;
                        break;
                case 13: 	
                        $wedgesize=  4;
                        break;
                case 14: 	
                        $wedgesize=  3;
                        break;
                case 15: 	
                        $wedgesize=  2;
                        break;
                case 16: 	
                        $wedgesize=  4;
                        break;
                case 17: 	
                        $wedgesize=  3;
                        break;
                case 18: 	
                        $wedgesize=  2;
                        break;
		default:
                        $wedgesize = 4;
                        break;
	}

	//FOR NORMAL DRAWING
	system('convert -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.' -stroke none -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);

	//FOR OUTLINE DRAWING
	if(($this->outline <> 'None'))
	{
		$stokewidthcmd=' -strokewidth '.$this->padding.' -stroke "#'.$this->outlinecolor.'"';
		system('convert -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.$stokewidthcmd.' -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
		system('composite -gravity center '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
		unlink(WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
	}
	system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -trim -bordercolor none -border 1 '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	$size = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	$width = $size[0];
	$height = $size[1];

	//FOR Distorted Wedge 

      if ($this->textShapeSettings == 1 || $this->textShapeSettings == 2 || $this->textShapeSettings == 3)
        system('convert -density '.$this->dpi.' -units pixelsperinch "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background transparent -distort Bilinear "0,0,0,'.($height/$wedgesize).'  0,'.$height.',0,'.$height.'  '.$width.',0,'.$width.',0  '.$width.','.$height.','.$width.','.$height.'" -trim -rotate '.$this->rot.' -trim '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
      else if ($this->textShapeSettings == 4 || $this->textShapeSettings == 5 || $this->textShapeSettings == 6)
        system('convert -density '.$this->dpi.' -units pixelsperinch "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background transparent -distort Bilinear "0,0,0,0  0,'.$height.',0,'.$height.'  '.$width.',0,'.$width.','.($height/$wedgesize).'  '.$width.','.$height.','.$width.','.$height.'" -trim -rotate '.$this->rot.' -trim '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
      else if ($this->textShapeSettings == 7 || $this->textShapeSettings == 8 || $this->textShapeSettings == 9)
        system('convert -density '.$this->dpi.' -units pixelsperinch "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background transparent -distort Bilinear "0,0,0,'.($height/$wedgesize).'  0,'.$height.',0,'.($height-$height/$wedgesize).'  '.$width.',0,'.$width.',0  '.$width.','.$height.','.$width.','.$height.'" -trim -rotate '.$this->rot.' -trim '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
      else if ($this->textShapeSettings == 10 || $this->textShapeSettings == 11 || $this->textShapeSettings == 12)
        system('convert -density '.$this->dpi.' -units pixelsperinch "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background transparent -distort Bilinear "0,0,0,0  0,'.$height.',0,'.$height.'  '.$width.',0,'.$width.','.($height/$wedgesize).'  '.$width.','.$height.','.$width.','.($height-$height/$wedgesize).'" -trim -rotate '.$this->rot.' -trim '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
      else if ($this->textShapeSettings == 13 || $this->textShapeSettings == 14 || $this->textShapeSettings == 15)
        system('convert -density '.$this->dpi.' -units pixelsperinch "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -distort Bilinear "0,0,0,0  0,'.$height.',0,'.($height-$height/$wedgesize).'  '.$width.',0,'.$width.',0  '.$width.','.$height.','.$width.','.$height.'" -trim -rotate '.$this->rot.' -trim '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
      else if ($this->textShapeSettings == 16 || $this->textShapeSettings == 17 || $this->textShapeSettings == 18)
        system('convert -density '.$this->dpi.' -units pixelsperinch "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background transparent -distort Bilinear "0,0,0,0  0,'.$height.',0,'.$height.'  '.$width.',0,'.$width.',0  '.$width.','.$height.','.$width.','.($height-$height/$wedgesize).'" -trim -rotate '.$this->rot.' -trim '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);

        //SUPERIMPOSE OVER THE FINAL IMAGE
        system('composite -geometry +' . $this->left . '+' . $this->top . ' ' . WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName . ' ' . $destImage . ' ' . $this->edited);
	
        
        $src=WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName;
        if(is_file($src)) {
        
        	//For SVG
        	$tmp = explode(".", $this->edited);
        	$this->editedImg_svg=$tmp[0].".svg";
        
        	$src_svg=explode(".",$src);
        	$src_svg=$src_svg[0].".gif";
        	system('convert -channel Alpha -threshold 80% '.$src." ".$src_svg);
        	 
        	// copy($src, WWW_ROOT . IMAGES_URL ."1.png");
        	if(file_exists($this->editedImg_svg))
        	{
        		 
        		$svg = SVGDocument::getInstance($this->editedImg_svg);
        		$svg->addShape( SVGImage::getInstance($this->left, $this->top, 'Text'.$this->editCount,$src_svg));
        		$svg->asXML($this->editedImg_svg);
        	}
        	
        	unlink($src_svg);
        
        }
        
        
        
        unlink(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	
    }
    
    private function drawRoof($destImage) {
	
	$pngName = time().rand(0, 9999).'.png';	
	
	switch ($this->textShapeSettings) {
            
		case 1: 
                        $roofsize = 4;
                        break;
		case 2: 	
                        $roofsize = 3;
                        break;
		case 3: 		
                        $roofsize = 2;
                        break;
		case 4: 		
                        $roofsize = 5;
                        break;
		case 5: 			
                        $roofsize = 4;
                        break;
		case 6: 		
                        $roofsize = 3;
                        break;
		case 7: 		
                        $roofsize = 4;
                        break;
		case 8:			
                        $roofsize = 3;
                        break;
		case 9: 		
                        $roofsize = 2;
                        break;
		case 10: 		
                        $roofsize = 5;
                        break;
		case 11: 			
                        $roofsize = 4;
                        break;
		case 12: 			
                        $roofsize = 3;
                        break;
		case 13: 			
                        $roofsize = 5;
                        break;
		case 14: 			
                        $roofsize = 4;
                        break;			
		case 15: 		
                        $roofsize = 3;
                        break;
		default:
                        $roofsize = 4;
                        break;
	}
	
	//FOR NORMAL DRAWING
	system('convert -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.' -stroke none -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	
        //FOR OUTLINE DRAWING	
	if(($this->outline <> 'None'))
	{
		$stokewidthcmd=' -strokewidth '.$this->padding.' -stroke "#'.$this->outlinecolor.'"';
		system('convert -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.$stokewidthcmd.' -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
		system('composite -gravity center '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
		unlink(WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
	}
	
	//Roof DRAWING
	$size = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	$width = $size[0];
	$height = $size[1];
	
	if ($this->textShapeSettings >= 1 && $this->textShapeSettings <= 9)
	{
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -extent '.($width/2).'x'.$height.' '.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName);
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -extent '.($width/2).'x'.$height.'+'.($width/2).'+0 '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
	else if ($this->textShapeSettings >= 10 && $this->textShapeSettings <= 12)
	{
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -extent '.($width/3).'x'.$height.' '.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName);
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -extent '.($width/3*2).'x'.$height.'+'.($width/3).'+0 '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
	else if ($this->textShapeSettings >= 13 && $this->textShapeSettings <= 15)
	{
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -extent '.($width/3*2).'x'.$height.' '.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName);
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -extent '.($width/3).'x'.$height.'+'.($width/3*2).'+0 '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
	
	$size1 = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName);
	$width1 = $size1[0];
	$height1 = $size1[1];
	
	
	$size2 = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	$width2 = $size2[0];
	$height2 = $size2[1];
	
	
	if ($this->textShapeSettings == 1 || $this->textShapeSettings == 2 || $this->textShapeSettings == 3)
	{
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName.'" -background none -distort Bilinear "0,0,0,'.($height1/$roofsize).' 0,'.$height1.',0,'.$height1.'  '.$width1.',0,'.$width1.',0 '.$width1.','.$height1.','.$width1.','.$height1.'" '.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName);
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -distort Bilinear "0,0,0,0 0,'.$height2.',0,'.$height2.' '.$width2.',0,'.$width2.','.($height2/$roofsize).' '.$width2.','.$height2.','.$width2.','.$height2.'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
	else if ($this->textShapeSettings == 7 || $this->textShapeSettings == 8 || $this->textShapeSettings == 9)
	{
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName.'" -background none -distort Bilinear "0,0,0,0 0,'.$height1.',0,'.($height1-$height1/$roofsize).' '.$width1.',0,'.$width1.',0 '.$width1.','.$height1.','.$width1.','.$height1.'" '.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName);
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -distort Bilinear "0,0,0,0 0,'.$height2.',0,'.$height2.'  '.$width2.',0,'.$width2.',0 '.$width2.','.$height2.','.$width2.','.($height2-$height2/$roofsize).'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
	else
	{
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName.'" -background none -distort Bilinear "0,0,0,'.($height1/$roofsize).' 0,'.$height1.',0,'.($height1-$height1/$roofsize).' '.$width1.',0,'.$width1.',0 '.$width1.','.$height1.','.$width1.','.$height1.'" '.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName);
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -distort Bilinear "0,0,0,0 0,'.$height2.',0,'.$height2.' '.$width2.',0,'.$width2.','.($height2/$roofsize).' '.$width2.','.$height2.','.$width2.','.($height2-$height2/$roofsize).'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
	
	
	system('convert '.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' -background none +append -rotate '.$this->rot.' -trim '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	
        //SUPERIMPOSE OVER THE FINAL IMAGE
        system('composite -geometry +' . $this->left . '+' . $this->top . ' ' . WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName . ' ' . $destImage . ' ' . $this->edited);
	 
        $src=WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName;
        if(is_file($src)) {
        
        	//For SVG
        	$tmp = explode(".", $this->edited);
        	$this->editedImg_svg=$tmp[0].".svg";
        	$src_svg=explode(".",$src);
        	$src_svg=$src_svg[0].".gif";
        	system('convert -channel Alpha -threshold 80% '.$src." ".$src_svg);
        	 
        	// copy($src, WWW_ROOT . IMAGES_URL ."1.png");
        	if(file_exists($this->editedImg_svg))
        	{
        		 
        		$svg = SVGDocument::getInstance($this->editedImg_svg);
        		$svg->addShape( SVGImage::getInstance($this->left, $this->top, 'Text'.$this->editCount,$src_svg));
        		$svg->asXML($this->editedImg_svg);
        	}
        	
        	unlink($src_svg);
        
        }
        
        
        
        unlink(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	
    }

    //---------------------------IMAGE SECTION--------------------------------//
    function addImage($imgVal) {

        if(is_array($imgVal)) {

            $this->left        = $imgVal['left'];
            $this->top         = $imgVal['top'];
            $this->imageSrc    = $imgVal['image'];

            $this->editCount++;
            $dest = $this->editCount == 1 ? $this->original : $this->edited;

            $this->imageSrc = str_replace("%20", " ", $this->imageSrc);
            $img  = explode(".", $this->imageSrc);
            $path = explode("/", $this->imageSrc);

            $src = WWW_ROOT . IMAGES_URL . "editorimages/" . $path[count($path) - 2] . "/" . $path[count($path) - 1];

            
           
            if(is_file($src)) {
                //SUPERIMPOSE OVER THE FINAL IMAGE
                system('composite -geometry +' . $this->left . '+' . $this->top . ' ' . $src . ' ' . $dest . ' ' . $this->edited);
            }
            
            
            if(is_file($src)) {
            
            	//For SVG
            	$tmp = explode(".", $this->edited);
            	$this->editedImg_svg=$tmp[0].".svg";
            	$src_svg=explode(".",$src);
            	$src_svg=$src_svg[0].".gif";
            	system('convert -channel Alpha -threshold 80% '.$src." ".$src_svg);
        	
            	// copy($src, WWW_ROOT . IMAGES_URL ."1.png");
            	if(file_exists($this->editedImg_svg))
            	{
            
            		$svg = SVGDocument::getInstance($this->editedImg_svg);
            		$svg->addShape( SVGImage::getInstance($this->left, $this->top, 'Image'.$this->editCount,$src_svg));
            		$svg->asXML($this->editedImg_svg);
            	}
            	
            	unlink($src_svg);
            
            }
            

        }
        
    }

    function __getmicrotime($e = 7) {
        list($u, $s) = explode(' ', microtime());
        return str_replace(".", "_", bcadd($u, $s, $e));
    }

    function __br2nl($s, $useReturn = false) {
        return preg_replace('/(<br ?\/?>)/i', (($useReturn) ? '/r' : '/n'), $s);
    }

}